;								EJEMPLO 26
;						Autor: Mikel Etxebarria
;			(c) Ingeniera de Microsistemas Programados S.L.
;						www.microcontroladores.com
;								Bilbao 2006
;
;El TMR2. Temporizacin simple, segundero
;
;El TMR2 provoca una interrupcin cada 10 mS. Transcurridas 100 interrupciones, el tiempo total
;transcurrido es de 1 segundo.
;
;Los leds conectados a la puerta B visualizan, en binario, el segundero
		
		List	p=16F876A		;Tipo de procesador
		include	"P16F876A.INC"	;Definiciones de registros internos

;Ajusta los valores de la palabra de configuracin durante el ensamblaje:
;proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

			__config _CP_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_XT_OSC

Delay			equ	0x20		;Variable de temporizacin

				org	0x00		;Vector de RESET	
				goto	Inicio
				org	0x04		;Vector de interrupcin
				goto	Inter
				org	0x05

;Programa de tratamiento de la interrupcin que provoca el TMR2 cada 10mS.

Inter		decfsz	Delay,F		;Ha pasado un segundo ??
			goto	No_es_1_seg	;No
			incf	PORTB,F		;Si, incrementa el contador de segundos
			movlw	.100
			movwf	Delay		;Reinicia variable delay
No_es_1_seg	bcf	PIR1,TMR2IF		;Repone el flag del TMR2
			retfie

;Programa principal

Inicio	   	clrf	PORTB		;Desconecta salidas pone a 0 el contador
			bsf		STATUS,RP0	;Selecciona banco 1
			clrf	TRISB		;Puerta B se configura como salida
			bsf		PIE1,TMR2IE	;Habilita interrupcin del TMR2
			movlw	.39
			movwf	PR2			;Carga registro de periodos con 39
			bcf		STATUS,RP0	;Selecciona banco 0

;El TMR2 emplea un preescaler y un postcaler de 1:16 (total 1:256). Trabajando a una
;frecuencia de 4MHZ el TMR2 evoluciona cada 16uS (preescaler 1:16). La cuenta avanza hasta
;alcanzar el valor del registro de periodos (39), con lo que el tiempo transcurrido es de
;624 uS. Este lapsus se repite 16 veces (postcaler 1:16) antes de provocar la interrupcin
;(al de 9984 uS).

			movlw	b'01111111'
			movwf	T2CON		;TMR2 On, preescaler/postcaler = 1:16
			clrf	TMR2		;Inicia el TMR2
			movlw	.100
			movwf	Delay		;Inicia variable de delay
			movlw	b'11000000'
			movwf	INTCON		;Habilita interrupciones
		
Loop		nop
			goto	Loop		;Bucle infinito		

			end					;Fin del programa fuente
